clear all;
close all;
clc;

% per capita GDP 2000 - 2017



euro_gdp = xlsread('Eurostat_real GDP per capita without short description', 'Sheet0', 'B52:S52'); 
us_gdp = xlsread('Eurostat_real GDP per capita without short description', 'Sheet0', 'B53:S53'); 
japan_gdp = xlsread('Eurostat_real GDP per capita without short description', 'Sheet0', 'B54:S54'); 
cn_gdp = xlsread('Eurostat_real GDP per capita without short description', 'Sheet0', 'B55:S55'); 
italy_gdp = xlsread('Eurostat_real GDP per capita without short description', 'Sheet0', 'B56:S56');
germany_gdp = xlsread('Eurostat_real GDP per capita without short description', 'Sheet0', 'B57:S57');


% normalise: index 2017 = 100;
euro_gdp_n  = euro_gdp/euro_gdp(8)*100; 
us_gdp_n  = us_gdp/us_gdp(8)*100;
japan_gdp_n  = japan_gdp/japan_gdp(8)*100;
cn_gdp_n  = cn_gdp/cn_gdp(8)*100;
italy_gdp_n  = italy_gdp/italy_gdp(8)*100;
germany_gdp_n  = germany_gdp/germany_gdp(8)*100;

save data.mat euro_gdp_n us_gdp_n japan_gdp_n cn_gdp_n italy_gdp_n germany_gdp_n
